import java.io.*;
import java.awt.*;
import java.awt.event.*;
import javax.xml.parsers.*;
import javax.xml.transform.*;
import javax.xml.transform.stream.*;
import javax.xml.transform.dom.*;
import javax.swing.*;
import org.w3c.dom.*;

public class CAD_JPrint extends JPanel implements Runnable, MouseListener, MouseMotionListener
{
	private Graphics graphics;
	private double zoom = 1.0;
	private String Print = "";
	private String strType1 = "";
	private String strType2 = "";
	private String strX = "";
	private String strY = "";
	private String strX1 = "";
	private String strY1 = "";
	private String strX2 = "";
	private String strY2 = "";
	private String strWidth = "";
	private String strHeight = "";
	private String strDegrees0 = "";
	private String strDegrees1 = "";
	private String strText = "";
	private String strColor = "";
	private String strFont1 = "";
	private String strFont2 = "";
	private String strSize = "";
	private static String mode = "line";
	private static String chfont = "Font.PLAIN";
	private static String chline = "RealLine";
	private static String chcolor = "Color.BLUE";
	private static String chbgcolor = "BGBLACK";
	private static int V = 0;
	private static int H = 0;
	private int structX = -1;
	private int structY = -1;
	private int clickX1 = -1;
	private int clickY1 = -1;
	private int clickX2 = -1;
	private int clickY2 = -1;
	private int clickContinueX1 = -1;
	private int clickContinueY1 = -1;
	private int clickContinueX2 = -1;
	private int clickContinueY2 = -1;
	private int clickRectX1 = -1;
	private int clickRectY1 = -1;
	private int clickRectX2 = -1;
	private int clickRectY2 = -1;
	private int clickX = -1;
	private int clickY = -1;
	private int clickWidth = -1;
	private int clickHeight = -1;
	private int clickDegrees0 = 0;
	private int clickDegrees1 = 0;
	private int clickTX = -1;
	private int clickTY = -1;
	private String clickFont = "Font.PLAIN";
	private String clickFontSize = "20";
	private String clickColor = "Color.BLUE";
	private String clickText = "";
	private int pointX = -1;
	private int pointY = -1;
	private int pointX1 = -1;
	private int pointY1 = -1;
	private int pointX2 = -1;
	private int pointY2 = -1;
	private int pointX3 = -1;
	private int pointY3 = -1;
	private int pointX4 = 0;
	private int pointY4 = 0;
	private int pointX5 = 0;
	private int pointY5 = 0;
	private int dotPointX1 = -1;
	private int dotPointY1 = -1;
	private int dotPointX2 = -1;
	private int dotPointY2 = -1;
	private int dotPointChangeX = -1;
	private int dotPointChangeY = -1;
	private int tmpPointX1 = -1;
	private int tmpPointY1 = -1;
	private int tmpPointX2 = -1;
	private int tmpPointY2 = -1;
	private int pd1 = 0;
	private int pd2 = 0;
	private int pd3 = 0;
	private boolean pd4 = false;
	private double pd5 = 0;
	private int CPDM = 7;
	private int CPDMOval = 15;
	// GCode
	CAD_GCode cgc;
	
	int width;
	int height;
	
	public CAD_JPrint(int w, int h) throws Exception
	{
		width = w;
		height = h;
		addMouseListener(this);
		addMouseMotionListener(this);
		// GCode
		cgc = new CAD_GCode();
		
		repaint();
	}
	
	public CAD_JPrint(File f) throws Exception
	{
		super();
		
		addMouseListener(this);
		addMouseMotionListener(this);
		
		repaint();
	}
	
	public void run()
	{
		while(true)
		{
			try{
				repaint();
				Thread.sleep(200);
			}catch(Exception e){}
		}
	}
	
	public void paint(Graphics g)
	{
		try{
			setGraphics(g);
			if(chbgcolor.equals("BGWHITE"))
			{
				g.setColor(Color.WHITE);
			}
			else
			{
				g.setColor(Color.BLACK);
			}
			g.fillRect(0, 0, width, height);
			if(mode.equals("atext"))
			{
				g.setColor(Color.YELLOW);
				g.drawLine((int) ((structX - H) * zoom), 0, (int) ((structX - H) * zoom), height);
				g.drawLine(0, (int) ((structY - V) * zoom), width, (int) ((structY - V) * zoom));
			}
			else if(mode.equals("line"))
			{
				g.setColor(Color.YELLOW);
				g.drawLine((int) ((structX - H) * zoom), 0, (int) ((structX - H) * zoom), height);
				g.drawLine(0, (int) ((structY - V) * zoom), width, (int) ((structY - V) * zoom));
				g.setColor(Color.RED);
				if((clickX1 != -1) || (clickY1 != -1))
				{
					g.drawLine((int) ((clickX1 - H) * zoom), (int) ((clickY1 - V) * zoom),
						(int) ((structX - H) * zoom), (int) ((structY - V) * zoom));
				}
			}
			else if(mode.equals("linecontinue"))
			{
				g.setColor(Color.YELLOW);
				g.drawLine((int) ((structX - H) * zoom), 0, (int) ((structX - H) * zoom), height);
				g.drawLine(0, (int) ((structY - V) * zoom), width, (int) ((structY - V) * zoom));
				g.setColor(Color.RED);
				if((clickContinueX1 != -1) || (clickContinueY1 != -1))
				{
					g.drawLine((int) ((clickContinueX1 - H) * zoom), (int) ((clickContinueY1 - V) * zoom),
						(int) ((structX - H) * zoom), (int) ((structY - V) * zoom));
				}
			}
			else if(mode.equals("rect"))
			{
				g.setColor(Color.YELLOW);
				g.drawLine((int) ((structX - H) * zoom), 0, (int) ((structX - H) * zoom), height);
				g.drawLine(0, (int) ((structY - V) * zoom), width, (int) ((structY - V) * zoom));
				g.setColor(Color.RED);
				if((clickRectX1 != -1) || (clickRectY1 != -1))
				{
					g.drawLine((int) ((clickRectX1 - H) * zoom), (int) ((clickRectY1 - V) * zoom),
						(int) ((structX - H) * zoom), (int) ((clickRectY1 - V) * zoom));
					g.drawLine((int) ((structX - H) * zoom), (int) ((clickRectY1 - V) * zoom),
						(int) ((structX - H) * zoom), (int) ((structY - V) * zoom));
					g.drawLine((int) ((structX - H) * zoom), (int) ((structY - V) * zoom),
						(int) ((clickRectX1 - H) * zoom), (int) ((structY - V) * zoom));
					g.drawLine((int) ((clickRectX1 - H) * zoom), (int) ((structY - V) * zoom),
						(int) ((clickRectX1 - H) * zoom), (int) ((clickRectY1 - V) * zoom));
				}
			}
			else if(mode.equals("oval"))
			{
				g.setColor(Color.YELLOW);
				g.drawLine((int) ((structX - H) * zoom), 0, (int) ((structX - H) * zoom), height);
				g.drawLine(0, (int) ((structY - V) * zoom), width, (int) ((structY - V) * zoom));
				g.setColor(Color.RED);
				if((clickX != -1) || (clickY != -1))
				{
					g.drawLine((int) ((clickX - H) * zoom), (int) ((clickY - V) * zoom),
						(int) ((structX - H) * zoom), (int) ((structY - V) * zoom));
				}
			}
			else if(mode.equals("move") || mode.equals("copy"))
			{
				g.setColor(Color.YELLOW);
				g.drawLine((int) ((tmpPointX1 - H) * zoom), (int) ((tmpPointY1 - V) * zoom),
					(int) ((tmpPointX2 - H) * zoom), (int) ((tmpPointY1 - V) * zoom));
				g.drawLine((int) ((tmpPointX2 - H) * zoom), (int) ((tmpPointY1 - V) * zoom),
					(int) ((tmpPointX2 - H) * zoom), (int) ((tmpPointY2 - V) * zoom));
				g.drawLine((int) ((tmpPointX2 - H) * zoom), (int) ((tmpPointY2 - V) * zoom),
					(int) ((tmpPointX1 - H) * zoom), (int) ((tmpPointY2 - V) * zoom));
				g.drawLine((int) ((tmpPointX1 - H) * zoom), (int) ((tmpPointY2 - V) * zoom),
					(int) ((tmpPointX1 - H) * zoom), (int) ((tmpPointY1 - V) * zoom));
			}
			else if(mode.equals("eraser"))
			{
				g.setColor(Color.YELLOW);
				g.drawLine((int) ((pointX1 - H) * zoom), (int) ((pointY1 - V) * zoom),
					(int) ((pointX2 - H) * zoom), (int) ((pointY1 - V) * zoom));
				g.drawLine((int) ((pointX2 - H) * zoom), (int) ((pointY1 - V) * zoom),
					(int) ((pointX2 - H) * zoom), (int) ((pointY2 - V) * zoom));
				g.drawLine((int) ((pointX2 - H) * zoom), (int) ((pointY2 - V) * zoom),
					(int) ((pointX1 - H) * zoom), (int) ((pointY2 - V) * zoom));
				g.drawLine((int) ((pointX1 - H) * zoom), (int) ((pointY2 - V) * zoom),
					(int) ((pointX1 - H) * zoom), (int) ((pointY1 - V) * zoom));
			}
			else if(mode.equals("zoom"))
			{
				try{
					BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
					System.out.print("Zoom[%] = ");
					zoom = Integer.parseInt(br.readLine()) / 100.0;
					mode = "move";
				}catch(Exception e){}
			}
			// Read DOM & current.xml
			// ---
			//
			int x1 = 0;
			int y1 = 0;
			int x2 = 0;
			int y2 = 0;
			int x = 0;
			int y = 0;
			int Width = 0;
			int Height = 0;
			int degrees0 = 0;
			int degrees1 = 360;
			int redX = 0;
			int redY = 0;
			strColor = chcolor;
			strType1 = "line";
			strType2 = chline;
			// GCode
			cgc.clear();
			
			DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
			DocumentBuilder db = dbf.newDocumentBuilder();
			Document doc = db.parse(new FileInputStream("current.xml"));
			Element root = doc.getDocumentElement();
			
			for(Node n = root.getFirstChild(); n != null; n = n.getNextSibling())
			{
				if(n.getNodeType() == Node.ELEMENT_NODE)
				{
					if(n.getNodeName().equals("shape"))
					{
						for(Node ch = n.getFirstChild(); ch != null; ch = ch.getNextSibling())
						{
							if(ch.getNodeType() == Node.ELEMENT_NODE)
							{
								if(ch.getNodeName().equals("text"))
								{
									strType1 = "text";
									strFont1 = "Sherif";
									try{
										strFont2 = ch.getAttributes().getNamedItem("Font").getNodeValue();
										strSize = ch.getAttributes().getNamedItem("FontSize").getNodeValue();
										strColor = ch.getAttributes().getNamedItem("Color").getNodeValue();
										strX = ch.getAttributes().getNamedItem("X").getNodeValue();
										strY = ch.getAttributes().getNamedItem("Y").getNodeValue();
									}catch(Exception e){}
									for(Node ch2 = ch.getFirstChild(); ch2 != null; ch2 = ch2.getNextSibling())
									{
										if(ch2.getNodeType() == Node.TEXT_NODE)
										{
											strText = ch2.getNodeValue();
										}
									}
									// setFont
									int s = 20;
									try{
										s = Integer.parseInt(strSize);
									}catch(Exception e){}
									g.setFont(new Font(strFont1, Font.PLAIN, s));
									if(strFont2.equals("Font.BOLD"))
									{
										g.setFont(new Font(strFont1, Font.BOLD, s));
									}
									else if(strFont2.equals("Font.ITALIC"))
									{
										g.setFont(new Font(strFont1, Font.ITALIC, s));
									}
									// setColor
									g.setColor(Color.BLUE);
									if(strColor.equals("Color.RED"))
									{
										g.setColor(Color.RED);
									}
									else if(strColor.equals("Color.YELLOW"))
									{
										g.setColor(Color.YELLOW);
									}
									else if(strColor.equals("Color.GREEN"))
									{
										g.setColor(Color.GREEN);
									}
									else if(strColor.equals("Color.CYAN"))
									{
										g.setColor(Color.CYAN);
									}
									else if(strColor.equals("Color.MAGENTA"))
									{
										g.setColor(Color.MAGENTA);
									}
									// mode
									if(mode.equals("move") || mode.equals("copy"))
									{
										redX = 0;
										redY = 0;
										if((tmpPointX1 != -1) && (tmpPointY1 != -1) && (tmpPointX2 != -1) && (tmpPointY2 != -1))
										{
											if(getDotPDistance(Integer.parseInt(strX), Integer.parseInt(strY),
												pointX1, pointY1, pointX2, pointY2))
											{
												g.setColor(Color.RED);
												if(((pointX3 != -1) && (pointY3 != -1)) && ((pointX4 != 0) || (pointY4 != 0)))
												{
													redX = pointX4;
													redY = pointY4;
												}
											}
										}
										if((pointX5 != 0) || (pointY5 != 0))
										{
											if(getDotPDistance(Integer.parseInt(strX), Integer.parseInt(strY),
												pointX1, pointY1, pointX2, pointY2))
											{
												redX = pointX5;
												redY = pointY5;
												Element elmCopyAText = doc.createElement("text");
												if(mode.equals("copy"))
												{
													n.appendChild(elmCopyAText);
													elmCopyAText.setAttribute("Font",
														ch.getAttributes().getNamedItem("Font").getNodeValue());
													elmCopyAText.setAttribute("FontSize",
														ch.getAttributes().getNamedItem("FontSize").getNodeValue());
													elmCopyAText.setAttribute("Color",
														ch.getAttributes().getNamedItem("Color").getNodeValue());
													elmCopyAText.setAttribute("X", (
														Integer.toString(Integer.parseInt(
														ch.getAttributes().getNamedItem("X").getNodeValue()) + redX)));
													elmCopyAText.setAttribute("Y", (
														Integer.toString(Integer.parseInt(
														ch.getAttributes().getNamedItem("Y").getNodeValue()) + redY)));
													for(Node ch2 = ch.getFirstChild(); ch2 != null; ch2 = ch2.getNextSibling())
													{
														if(ch2.getNodeType() == Node.TEXT_NODE)
														{
															Text elmCopyText = doc.createTextNode(ch2.getNodeValue());
															elmCopyAText.appendChild(elmCopyText);
														}
													}
												}
												else if(mode.equals("move"))
												{
													Element elmXY = (Element) ch;
													elmXY.setAttribute("X", Integer.toString(
														Integer.parseInt(ch.getAttributes().getNamedItem("X").getNodeValue()) + redX));
													elmXY.setAttribute("Y", Integer.toString(
														Integer.parseInt(ch.getAttributes().getNamedItem("Y").getNodeValue()) + redY));
													n.removeChild(ch);
													n.appendChild((Node) elmXY);
												}
											}
										}
									}
									else if(mode.equals("eraser"))
									{
										if((pointX1 != -1) && (pointY1 != -1) && (pointX2 != -1) && (pointY2 != -1))
										{
											if(getDotPDistance(Integer.parseInt(strX), Integer.parseInt(strY),
												pointX1, pointY1, pointX2, pointY2))
											{
												n.removeChild(ch);
												TransformerFactory tff = TransformerFactory.newInstance();
												Transformer tf = tff.newTransformer();
												tf.setOutputProperty(OutputKeys.ENCODING, "Shift_JIS");
												tf.transform(new DOMSource(doc), new StreamResult("current.xml"));
												continue;
											}
										}
									}
									g.drawString(strText, (int) ((Integer.parseInt(strX) + redX - H) * zoom),
										(int) ((Integer.parseInt(strY) + redY - V) * zoom));
								}
								if(ch.getNodeName().equals("line"))
								{
									strType1 = "line";
									try{
										strType2 = ch.getAttributes().getNamedItem("Line").getNodeValue();
										strColor = ch.getAttributes().getNamedItem("Color").getNodeValue();
									}catch(Exception e){}
									int ix = 0;
									int iy = 0;
									for(Node ch2 = ch.getFirstChild(); ch2 != null; ch2 = ch2.getNextSibling())
									{
										if(ch2.getNodeType() == Node.ELEMENT_NODE)
										{
											if(ch2.getNodeName().equals("dot"))
											{
												for(Node ch3 = ch2.getFirstChild(); ch3 != null; ch3 = ch3.getNextSibling())
												{
													if(ch3.getNodeType() == Node.ELEMENT_NODE)
													{
														if(ch3.getNodeName().equals("x"))
														{
															for(Node ch4 = ch3.getFirstChild(); ch4 != null; ch4 = ch4.getNextSibling())
															{
																if(ch4.getNodeType() == Node.TEXT_NODE)
																{
																	if(ix == 0)
																	{
																		strX1 = ch4.getNodeValue();
																		x1 = Integer.parseInt(strX1);
																		dotPointX1 = x1;
																	}
																	if(ix == 1)
																	{
																		strX2 = ch4.getNodeValue();
																		x2 = Integer.parseInt(strX2);
																		dotPointX2 = x2;
																	}
																	ix++;
																}
															}
														}
														else if(ch3.getNodeName().equals("y"))
														{
															for(Node ch4 = ch3.getFirstChild(); ch4 != null; ch4 = ch4.getNextSibling())
															{
																if(ch4.getNodeType() == Node.TEXT_NODE)
																{
																	if(iy == 0)
																	{
																		strY1 = ch4.getNodeValue();
																		y1 = Integer.parseInt(strY1);
																		dotPointY1 = y1;
																	}
																	if(iy == 1)
																	{
																		strY2 = ch4.getNodeValue();
																		y2 = Integer.parseInt(strY2);
																		dotPointY2 = y2;
																		break;
																	}
																	iy++;
																}
															}
														}
													}
												}
											}
										}
									}
									if(strType1.equals("line"))
									{
										//dotPointX, dotPointY
										if((mode.equals("line")) || (mode.equals("linecontinue"))
											|| (mode.equals("rect")) || (mode.equals("pointer")))
										{
											if(getDotPDistance(structX, structY, dotPointX1,
												dotPointY1, dotPointX1, dotPointY1))
											{
												g.setColor(Color.PINK);
												g.drawArc(((int) ((dotPointX1 - H) * zoom)) - 5,
													((int) ((dotPointY1 - V) * zoom)) - 5,
													10, 10, 0, 360);
												if(getDotPDistance(clickX1, clickY1, dotPointX1,
													dotPointY1, dotPointX1, dotPointY1))
												{
													if((clickX2 == -1) && (clickY2 == -1))
													{
														clickX1 = dotPointX1;
														clickY1 = dotPointY1;
													}
												}
												if(getDotPDistance(clickContinueX1, clickContinueY1, dotPointX1,
													dotPointY1, dotPointX1, dotPointY1))
												{
													if((clickContinueX2 == -1) && (clickContinueY2 == -1))
													{
														clickContinueX1 = dotPointX1;
														clickContinueY1 = dotPointY1;
													}
												}
												if(getDotPDistance(clickRectX1, clickRectY1, dotPointX1,
													dotPointY1, dotPointX1, dotPointY1))
												{
													if((clickRectX2 == -1) && (clickRectY2 == -1))
													{
														clickRectX1 = dotPointX1;
														clickRectY1 = dotPointY1;
													}
												}
											}
											if(getDotPDistance(structX, structY, dotPointX2,
												dotPointY2, dotPointX2, dotPointY2))
											{
												g.setColor(Color.PINK);
												g.drawArc(((int) ((dotPointX2 - H) * zoom)) - 5,
													((int) ((dotPointY2 - V) * zoom)) - 5,
													10, 10, 0, 360);
												if(getDotPDistance(clickX1, clickY1, dotPointX2,
													dotPointY2, dotPointX2, dotPointY2))
												{
													if((clickX2 == -1) && (clickY2 == -1))
													{
														clickX1 = dotPointX2;
														clickY1 = dotPointY2;
													}
												}
												if(getDotPDistance(clickContinueX1, clickContinueY1, dotPointX2,
													dotPointY2, dotPointX2, dotPointY2))
												{
													if((clickContinueX2 == -1) && (clickContinueY2 == -1))
													{
														clickContinueX1 = dotPointX2;
														clickContinueY1 = dotPointY2;
													}
												}
												if(getDotPDistance(clickRectX1, clickRectY1, dotPointX2,
													dotPointY2, dotPointX2, dotPointY2))
												{
													if((clickRectX2 == -1) && (clickRectY2 == -1))
													{
														clickRectX1 = dotPointX2;
														clickRectY1 = dotPointY2;
													}
												}
											}
											dotPointX1 = dotPointX2 = -1;
											dotPointY1 = dotPointY2 = -1;
										}
										// setColor
										g.setColor(Color.BLUE);
										if(strColor.equals("Color.RED"))
										{
											g.setColor(Color.RED);
										}
										else if(strColor.equals("Color.YELLOW"))
										{
											g.setColor(Color.YELLOW);
										}
										else if(strColor.equals("Color.GREEN"))
										{
											g.setColor(Color.GREEN);
										}
										else if(strColor.equals("Color.CYAN"))
										{
											g.setColor(Color.CYAN);
										}
										else if(strColor.equals("Color.MAGENTA"))
										{
											g.setColor(Color.MAGENTA);
										}
										// mode
										if(mode.equals("move") || mode.equals("copy"))
										{
											redX = 0;
											redY = 0;
											if((tmpPointX1 != -1) && (tmpPointY1 != -1) && (tmpPointX2 != -1) && (tmpPointY2 != -1))
											{
												if(getPDistance(x1, y1, x2, y2))
												{
													g.setColor(Color.RED);
													if(((pointX3 != -1) && (pointY3 != -1)) && ((pointX4 != 0) || (pointY4 != 0)))
													{
														redX = pointX4;
														redY = pointY4;
													}
												}
											}
											if((pointX5 != 0) || (pointY5 != 0))
											{
												if(getPDistance(x1, y1, x2, y2))
												{
													redX = pointX5;
													redY = pointY5;
													Element elmCopyLine = doc.createElement("line");
													if(mode.equals("copy"))
													{
														n.appendChild(elmCopyLine);
														elmCopyLine.setAttribute("Line",
															ch.getAttributes().getNamedItem("Line").getNodeValue());
														elmCopyLine.setAttribute("Color",
															ch.getAttributes().getNamedItem("Color").getNodeValue());
													}
													for(Node ch2 = ch.getFirstChild(); ch2 != null; ch2 = ch2.getNextSibling())
													{
														if(ch2.getNodeType() == Node.ELEMENT_NODE)
														{
															if(ch2.getNodeName().equals("dot"))
															{
																Element elmCopyDot = doc.createElement("dot");
																if(mode.equals("copy"))
																{
																	elmCopyLine.appendChild(elmCopyDot);
																}
																for(Node ch3 = ch2.getFirstChild(); ch3 != null; ch3 = ch3.getNextSibling())
																{
																	if(ch3.getNodeType() == Node.ELEMENT_NODE)
																	{
																		if(ch3.getNodeName().equals("x"))
																		{
																			Element elmCopyX = doc.createElement("x");
																			if(mode.equals("copy"))
																			{
																				elmCopyDot.appendChild(elmCopyX);
																			}
																			for(Node ch4 = ch3.getFirstChild(); ch4 != null; ch4 = ch4.getNextSibling())
																			{
																				if(ch4.getNodeType() == Node.TEXT_NODE)
																				{
																					if(mode.equals("copy"))
																					{
																						Text elmCopyText = doc.createTextNode(
																							Integer.toString(Integer.parseInt(ch4.getNodeValue()) + redX));
																						elmCopyX.appendChild(elmCopyText);
																					}
																					else if(mode.equals("move"))
																					{
																						Text txtX = doc.createTextNode(
																							Integer.toString(Integer.parseInt(ch4.getNodeValue()) + redX));
																						ch3.removeChild(ch4);
																						ch3.appendChild(txtX);
																					}
																				}
																			}
																		}
																		else if(ch3.getNodeName().equals("y"))
																		{
																			Element elmCopyY = doc.createElement("y");
																			if(mode.equals("copy"))
																			{
																				elmCopyDot.appendChild(elmCopyY);
																			}
																			for(Node ch4 = ch3.getFirstChild(); ch4 != null; ch4 = ch4.getNextSibling())
																			{
																				if(ch4.getNodeType() == Node.TEXT_NODE)
																				{
																					if(mode.equals("copy"))
																					{
																						Text elmCopyText = doc.createTextNode(
																							Integer.toString(Integer.parseInt(ch4.getNodeValue()) + redY));
																						elmCopyY.appendChild(elmCopyText);
																					}
																					else if(mode.equals("move"))
																					{
																						Text txtY = doc.createTextNode(
																							Integer.toString(Integer.parseInt(ch4.getNodeValue()) + redY));
																						ch3.removeChild(ch4);
																						ch3.appendChild(txtY);
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
										else if(mode.equals("eraser"))
										{
											if((pointX1 != -1) && (pointY1 != -1) && (pointX2 != -1) && (pointY2 != -1))
											{
												if(getPDistance(x1, y1, x2, y2))
												{
													n.removeChild(ch);
													TransformerFactory tff = TransformerFactory.newInstance();
													Transformer tf = tff.newTransformer();
													tf.setOutputProperty(OutputKeys.ENCODING, "Shift_JIS");
													tf.transform(new DOMSource(doc), new StreamResult("current.xml"));
													continue;
												}
											}
										}
										else if(mode.equals("pointer"))
										{
											if((dotPointChangeX != -1) && (dotPointChangeY != -1))
											{
												BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
												String tmpStrX = "";
												String tmpStrY = "";
												for(Node ch2 = ch.getFirstChild(); ch2 != null; ch2 = ch2.getNextSibling())
												{
													if(ch2.getNodeType() == Node.ELEMENT_NODE)
													{
														if(ch2.getNodeName().equals("dot"))
														{
															for(Node ch3 = ch2.getFirstChild(); ch3 != null; ch3 = ch3.getNextSibling())
															{
																if(ch3.getNodeType() == Node.ELEMENT_NODE)
																{
																	if(ch3.getNodeName().equals("x"))
																	{
																		for(Node ch4 = ch3.getFirstChild(); ch4 != null; ch4 = ch4.getNextSibling())
																		{
																			if(ch4.getNodeType() == Node.TEXT_NODE)
																			{
																				tmpStrX = Integer.toString(
																					Integer.parseInt(
																					ch4.getNodeValue()));
																			}
																		}
																	}
																	else if(ch3.getNodeName().equals("y"))
																	{
																		for(Node ch4 = ch3.getFirstChild(); ch4 != null; ch4 = ch4.getNextSibling())
																		{
																			if(ch4.getNodeType() == Node.TEXT_NODE)
																			{
																				tmpStrY = Integer.toString(
																					Integer.parseInt(
																					ch4.getNodeValue()));
																			}
																		}
																	}
																}
															}
															if(getDotPDistance(
																Integer.parseInt(tmpStrX), Integer.parseInt(tmpStrY),
																dotPointChangeX, dotPointChangeY,
																dotPointChangeX, dotPointChangeY))
															{
																g.setColor(Color.RED);
																System.out.println("(x, y) = (" + tmpStrX + ", " + tmpStrY + ")");
																System.out.print("x = ");
																tmpStrX = br.readLine();
																Text txtX = doc.createTextNode(tmpStrX);
																System.out.print("y = ");
																tmpStrY = br.readLine();
																Text txtY = doc.createTextNode(tmpStrY);
																tmpStrX = "-20";
																tmpStrY = "-20";
																for(Node ch3 = ch2.getFirstChild(); ch3 != null; ch3 = ch3.getNextSibling())
																{
																	if(ch3.getNodeType() == Node.ELEMENT_NODE)
																	{
																		if(ch3.getNodeName().equals("x"))
																		{
																			for(Node ch4 = ch3.getFirstChild(); ch4 != null; ch4 = ch4.getNextSibling())
																			{
																				if(ch4.getNodeType() == Node.TEXT_NODE)
																				{
																					ch3.removeChild(ch4);
																					ch3.appendChild(txtX);
																				}
																			}
																		}
																		else if(ch3.getNodeName().equals("y"))
																		{
																			for(Node ch4 = ch3.getFirstChild(); ch4 != null; ch4 = ch4.getNextSibling())
																			{
																				if(ch4.getNodeType() == Node.TEXT_NODE)
																				{
																					ch3.removeChild(ch4);
																					ch3.appendChild(txtY);
																				}
																			}
																		}
																	}
																}
																continue;
															}
														}
													}
												}
											}
										}
										// drawRealLine
										if(strType2.equals("RealLine"))
										{
											for(int i = -1; i < 2; i++)
											{
												for(int j = -1; j < 2; j++)
												{
													g.drawLine((int) ((x1 + redX - H) * zoom) + i,
													 (int) ((y1 + redY - V) * zoom) + j,
													 (int) ((x2 + redX - H) * zoom) + i,
													 (int) ((y2 + redY - V) * zoom) + j);
												}
											}
										}
										// drawArrowLine
										else if(strType2.equals("ArrowLine"))
										{
											g.drawLine((int) ((x1 + redX - H) * zoom),
											 (int) ((y1 + redY - V) * zoom),
											 (int) ((x2 + redX - H) * zoom),
											 (int) ((y2 + redY - V) * zoom));
											// drawArrow
											double rad;
											int fugoX;
											int fugoY;
											rad = 0;
											fugoX = 1;
											fugoY = 1;
											if(x2 > x1)
											{
												fugoX = 1;
											}
											else if(x2 < x1)
											{
												fugoX = (-1);
											}
											
											if(y2 > y1)
											{
												fugoY = 1;
											}
											else if(y2 < y1)
											{
												fugoY = (-1);
											}
											
											if(x1 == x2)
											{
												rad = (Math.PI / 2);
											}
											else
											{
												rad = Math.atan((y2 - y1) / (x2 - x1));
												
												if(rad < 0)
												{
													rad = -rad;
												}
											}
											g.drawLine((int) ((x1 + redX - H) * zoom),
											 (int) ((y1 + redY - V) * zoom),
											 (int) (((x1 + redX - H) * zoom) + fugoX * 10 * Math.cos(rad + (Math.PI / 6))),
											 (int) (((y1 + redY - V) * zoom) + fugoY * 10 * Math.sin(rad + (Math.PI / 6))));
											g.drawLine((int) ((x1 + redX - H) * zoom),
											 (int) ((y1 + redY - V) * zoom),
											 (int) (((x1 + redX - H) * zoom) + fugoX * 10 * Math.cos(rad - (Math.PI / 6))),
											 (int) (((y1 + redY - V) * zoom) + fugoY * 10 * Math.sin(rad - (Math.PI / 6))));
											rad += Math.PI;
											g.drawLine((int) ((x2 + redX - H) * zoom),
											 (int) ((y2 + redY - V) * zoom),
											 (int) (((x2 + redX - H) * zoom) + fugoX * 10 * Math.cos(rad + (Math.PI / 6))),
											 (int) (((y2 + redY - V) * zoom) + fugoY * 10 * Math.sin(rad + (Math.PI / 6))));
											g.drawLine((int) ((x2 + redX - H) * zoom),
											 (int) ((y2 + redY - V) * zoom),
											 (int) (((x2 + redX - H) * zoom) + fugoX * 10 * Math.cos(rad - (Math.PI / 6))),
											 (int) (((y2 + redY - V) * zoom) + fugoY * 10 * Math.sin(rad - (Math.PI / 6))));
										}
										// drawSubLine
										else
										{
											g.drawLine((int) ((x1 + redX - H) * zoom), (int) ((y1 + redY - V) * zoom),
											 (int) ((x2 + redX - H) * zoom), (int) ((y2 + redY - V) * zoom));
										}
										// GCode
										cgc.G01(strType2, x1, y1, x2, y2);
									}
								}
								else if(ch.getNodeName().equals("oval"))
								{
									strType1 = "oval";
									try{
										strType2 = ch.getAttributes().getNamedItem("Line").getNodeValue();
										strColor = ch.getAttributes().getNamedItem("Color").getNodeValue();
									}catch(Exception e){}
									for(Node ch2 = ch.getFirstChild(); ch2 != null; ch2 = ch2.getNextSibling())
									{
										if(ch2.getNodeType() == Node.ELEMENT_NODE)
										{
											if(ch2.getNodeName().equals("x"))
											{
												for(Node ch3 = ch2.getFirstChild(); ch3 != null; ch3 = ch3.getNextSibling())
												{
													if(ch3.getNodeType() == Node.TEXT_NODE)
													{
														strX = ch3.getNodeValue();
														x = Integer.parseInt(strX);
													}
												}
											}
											else if(ch2.getNodeName().equals("y"))
											{
												for(Node ch3 = ch2.getFirstChild(); ch3 != null; ch3 = ch3.getNextSibling())
												{
													if(ch3.getNodeType() == Node.TEXT_NODE)
													{
														strY = ch3.getNodeValue();
														y = Integer.parseInt(strY);
													}
												}
											}
											if(ch2.getNodeName().equals("width"))
											{
												for(Node ch3 = ch2.getFirstChild(); ch3 != null; ch3 = ch3.getNextSibling())
												{
													if(ch3.getNodeType() == Node.TEXT_NODE)
													{
														strWidth = ch3.getNodeValue();
														Width = Integer.parseInt(strWidth);
													}
												}
											}
											else if(ch2.getNodeName().equals("height"))
											{
												for(Node ch3 = ch2.getFirstChild(); ch3 != null; ch3 = ch3.getNextSibling())
												{
													if(ch3.getNodeType() == Node.TEXT_NODE)
													{
														strHeight = ch3.getNodeValue();
														Height = Integer.parseInt(strHeight);
													}
												}
											}
											if(ch2.getNodeName().equals("degrees0"))
											{
												for(Node ch3 = ch2.getFirstChild(); ch3 != null; ch3 = ch3.getNextSibling())
												{
													if(ch3.getNodeType() == Node.TEXT_NODE)
													{
														strDegrees0 = ch3.getNodeValue();
														degrees0 = Integer.parseInt(strDegrees0);
													}
												}
											}
											else if(ch2.getNodeName().equals("degrees1"))
											{
												for(Node ch3 = ch2.getFirstChild(); ch3 != null; ch3 = ch3.getNextSibling())
												{
													if(ch3.getNodeType() == Node.TEXT_NODE)
													{
														strDegrees1 = ch3.getNodeValue();
														degrees1 = Integer.parseInt(strDegrees1);
													}
												}
											}
										}
									}
									if(strType1.equals("oval"))
									{
										// setColor
										g.setColor(Color.BLUE);
										if(strColor.equals("Color.RED"))
										{
											g.setColor(Color.RED);
										}
										else if(strColor.equals("Color.YELLOW"))
										{
											g.setColor(Color.YELLOW);
										}
										else if(strColor.equals("Color.GREEN"))
										{
											g.setColor(Color.GREEN);
										}
										else if(strColor.equals("Color.CYAN"))
										{
											g.setColor(Color.CYAN);
										}
										else if(strColor.equals("Color.MAGENTA"))
										{
											g.setColor(Color.MAGENTA);
										}
										// mode
										if(mode.equals("move") || mode.equals("copy"))
										{
											redX = 0;
											redY = 0;
											if((tmpPointX1 != -1) && (tmpPointY1 != -1) && (tmpPointX2 != -1) && (tmpPointY2 != -1))
											{
												if(getOvalPDistance(x, y, Width, Height))
												{
													g.setColor(Color.RED);
													if(((pointX3 != -1) && (pointY3 != -1)) && ((pointX4 != 0) || (pointY4 != 0)))
													{
														redX = pointX4;
														redY = pointY4;
													}
												}
											}
											if((pointX5 != 0) || (pointY5 != 0))
											{
												if(getOvalPDistance(x, y, Width, Height))
												{
													redX = pointX5;
													redY = pointY5;
													Element elmCopyOval = doc.createElement("oval");
													if(mode.equals("copy"))
													{
														n.appendChild(elmCopyOval);
														elmCopyOval.setAttribute("Line",
															ch.getAttributes().getNamedItem("Line").getNodeValue());
														elmCopyOval.setAttribute("Color",
															ch.getAttributes().getNamedItem("Color").getNodeValue());
													}
													for(Node ch2 = ch.getFirstChild(); ch2 != null; ch2 = ch2.getNextSibling())
													{
														if(ch2.getNodeType() == Node.ELEMENT_NODE)
														{
															if(ch2.getNodeName().equals("x"))
															{
																Element elmCopyX = doc.createElement("x");
																if(mode.equals("copy"))
																{
																	elmCopyOval.appendChild(elmCopyX);
																}
																for(Node ch3 = ch2.getFirstChild(); ch3 != null; ch3 = ch3.getNextSibling())
																{
																	if(ch3.getNodeType() == Node.TEXT_NODE)
																	{
																		if(mode.equals("copy"))
																		{
																			Text elmCopyText = doc.createTextNode(
																				Integer.toString(Integer.parseInt(ch3.getNodeValue()) + redX));
																			elmCopyX.appendChild(elmCopyText);
																		}
																		else if(mode.equals("move"))
																		{
																			Text txtX = doc.createTextNode(
																				Integer.toString(Integer.parseInt(ch3.getNodeValue()) + redX));
																			ch2.removeChild(ch3);
																			ch2.appendChild(txtX);
																		}
																	}
																}
															}
															else if(ch2.getNodeName().equals("y"))
															{
																Element elmCopyY = doc.createElement("y");
																if(mode.equals("copy"))
																{
																	elmCopyOval.appendChild(elmCopyY);
																}
																for(Node ch3 = ch2.getFirstChild(); ch3 != null; ch3 = ch3.getNextSibling())
																{
																	if(ch3.getNodeType() == Node.TEXT_NODE)
																	{
																		if(mode.equals("copy"))
																		{
																			Text elmCopyText = doc.createTextNode(
																				Integer.toString(Integer.parseInt(ch3.getNodeValue()) + redY));
																			elmCopyY.appendChild(elmCopyText);
																		}
																		else if(mode.equals("move"))
																		{
																			Text txtY = doc.createTextNode(
																				Integer.toString(Integer.parseInt(ch3.getNodeValue()) + redY));
																			ch2.removeChild(ch3);
																			ch2.appendChild(txtY);
																		}
																	}
																}
															}
															else if(ch2.getNodeName().equals("width"))
															{
																Element elmCopyWidth = doc.createElement("width");
																if(mode.equals("copy"))
																{
																	elmCopyOval.appendChild(elmCopyWidth);
																}
																for(Node ch3 = ch2.getFirstChild(); ch3 != null; ch3 = ch3.getNextSibling())
																{
																	if(ch3.getNodeType() == Node.TEXT_NODE)
																	{
																		if(mode.equals("copy"))
																		{
																			Text elmCopyText = doc.createTextNode(
																				Integer.toString(Integer.parseInt(ch3.getNodeValue())));
																			elmCopyWidth.appendChild(elmCopyText);
																		}
																	}
																}
															}
															else if(ch2.getNodeName().equals("height"))
															{
																Element elmCopyHeight = doc.createElement("height");
																if(mode.equals("copy"))
																{
																	elmCopyOval.appendChild(elmCopyHeight);
																}
																for(Node ch3 = ch2.getFirstChild(); ch3 != null; ch3 = ch3.getNextSibling())
																{
																	if(ch3.getNodeType() == Node.TEXT_NODE)
																	{
																		if(mode.equals("copy"))
																		{
																			Text elmCopyText = doc.createTextNode(
																				Integer.toString(Integer.parseInt(ch3.getNodeValue())));
																			elmCopyHeight.appendChild(elmCopyText);
																		}
																	}
																}
															}
															else if(ch2.getNodeName().equals("degrees0"))
															{
																Element elmCopyDegrees0 = doc.createElement("degrees0");
																if(mode.equals("copy"))
																{
																	elmCopyOval.appendChild(elmCopyDegrees0);
																}
																for(Node ch3 = ch2.getFirstChild(); ch3 != null; ch3 = ch3.getNextSibling())
																{
																	if(ch3.getNodeType() == Node.TEXT_NODE)
																	{
																		if(mode.equals("copy"))
																		{
																			Text elmCopyText = doc.createTextNode(
																				Integer.toString(Integer.parseInt(ch3.getNodeValue())));
																			elmCopyDegrees0.appendChild(elmCopyText);
																		}
																	}
																}
															}
															else if(ch2.getNodeName().equals("degrees1"))
															{
																Element elmCopyDegrees1 = doc.createElement("degrees1");
																if(mode.equals("copy"))
																{
																	elmCopyOval.appendChild(elmCopyDegrees1);
																}
																for(Node ch3 = ch2.getFirstChild(); ch3 != null; ch3 = ch3.getNextSibling())
																{
																	if(ch3.getNodeType() == Node.TEXT_NODE)
																	{
																		if(mode.equals("copy"))
																		{
																			Text elmCopyText = doc.createTextNode(
																				Integer.toString(Integer.parseInt(ch3.getNodeValue())));
																			elmCopyDegrees1.appendChild(elmCopyText);
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
										else if(mode.equals("eraser"))
										{
											if((pointX1 != -1) && (pointY1 != -1) && (pointX2 != -1) && (pointY2 != -1))
											{
												if(getOvalPDistance(x, y, Width, Height))
												{
													n.removeChild(ch);
													TransformerFactory tff = TransformerFactory.newInstance();
													Transformer tf = tff.newTransformer();
													tf.setOutputProperty(OutputKeys.ENCODING, "Shift_JIS");
													tf.transform(new DOMSource(doc), new StreamResult("current.xml"));
													continue;
												}
											}
										}
										// drawOval
										if(width < 0) width = -width;
										if(height < 0) height = -height;
										
										if(strType2.equals("RealLine"))
										{
											for(int i = -1; i <= 1; i++)
											{
												for(int j = -1; j <= 1; j++)
												{
													g.drawArc(((int) (((x + redX) - (Width / 2.0) - H) * zoom)) + i,
														((int) (((y + redY) - (Height / 2.0) - V) * zoom)) + j,
														((int) (Width * zoom)), ((int) (Height * zoom)),
														degrees0, degrees1);
												}
											}
										}
										else
										{
											g.drawArc(((int) (((x + redX) - (Width / 2.0) - H) * zoom)),
												((int) (((y + redY) - (Height / 2.0) - V) * zoom)),
												((int) (Width * zoom)), ((int) (Height * zoom)),
												degrees0, degrees1);
										}
										// GCode
										cgc.G03(strType2, x, y, Width, Height, degrees0, degrees1);
									}
								}
							}
						}
					}
				}
			}
			if((pointX5 != 0) || (pointY5 != 0))
			{
				pointX1 = -1;
				pointY1 = -1;
				pointX2 = -1;
				pointY2 = -1;
				pointX3 = -1;
				pointY3 = -1;
				pointX4 = 0;
				pointY4 = 0;
				pointX5 = 0;
				pointY5 = 0;
				tmpPointX1 = -1;
				tmpPointY1 = -1;
				tmpPointX2 = -1;
				tmpPointY2 = -1;
			}
			if((dotPointChangeX != -1) || (dotPointChangeY != -1))
			{
				dotPointChangeX = -1;
				dotPointChangeY = -1;
			}
			
			TransformerFactory tff = TransformerFactory.newInstance();
			Transformer tf = tff.newTransformer();
			tf.setOutputProperty(OutputKeys.ENCODING, "Shift_JIS");
			tf.transform(new DOMSource(doc), new StreamResult("current.xml"));
		}catch(Exception e){}
	}
	
	public void setZoom(double z)
	{
		zoom = z / 100.0;
	}
	
	public double getZoom()
	{
		return (zoom * 100.0);
	}
	private void PrintLn(int x, int y, String font,
		String size, String str, String color) throws Exception
	{
		DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
		DocumentBuilder db = dbf.newDocumentBuilder();
		Document doc = db.parse(new FileInputStream("current.xml"));
		Element root = doc.getDocumentElement();
		for(Node n = root.getFirstChild(); n != null; n.getNextSibling())
		{
			if(n.getNodeType() == Node.ELEMENT_NODE)
			{
				if(n.getNodeName().equals("shape"))
				{
					Element text = doc.createElement("text");
					Text txt = doc.createTextNode(str);
					n.appendChild(text);
					text.appendChild(txt);
					text.setAttribute("Font", font);
					text.setAttribute("FontSize", size);
					text.setAttribute("Color", color);
					text.setAttribute("X", Integer.toString(x));
					text.setAttribute("Y", Integer.toString(y));
					TransformerFactory tff = TransformerFactory.newInstance();
					Transformer tf = tff.newTransformer();
					tf.setOutputProperty(OutputKeys.ENCODING, "Shift_JIS");
					tf.transform(new DOMSource(doc), new StreamResult("current.xml"));
					break;
				}
			}
		}
	}
	private void writeLine(String type, int x1, int y1,
		int x2, int y2, String color) throws Exception
	{
		DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
		DocumentBuilder db = dbf.newDocumentBuilder();
		Document doc = db.parse(new FileInputStream("current.xml"));
		Element root = doc.getDocumentElement();
		for(Node n = root.getFirstChild(); n != null; n.getNextSibling())
		{
			if(n.getNodeType() == Node.ELEMENT_NODE)
			{
				if(n.getNodeName().equals("shape"))
				{
					Element Line = doc.createElement("line");
					n.appendChild(Line);
					Line.setAttribute("Line", type);
					Line.setAttribute("Color", color);
					Element Dot1 = doc.createElement("dot");
					Line.appendChild(Dot1);
					Element X1 = doc.createElement("x");
					Dot1.appendChild(X1);
					Text txtX1 = doc.createTextNode(Integer.toString(x1));
					X1.appendChild(txtX1);
					Element Y1 = doc.createElement("y");
					Dot1.appendChild(Y1);
					Text txtY1 = doc.createTextNode(Integer.toString(y1));
					Y1.appendChild(txtY1);
					Element Dot2 = doc.createElement("dot");
					Line.appendChild(Dot2);
					Element X2 = doc.createElement("x");
					Dot2.appendChild(X2);
					Text txtX2 = doc.createTextNode(Integer.toString(x2));
					X2.appendChild(txtX2);
					Element Y2 = doc.createElement("y");
					Dot2.appendChild(Y2);
					Text txtY2 = doc.createTextNode(Integer.toString(y2));
					Y2.appendChild(txtY2);
					TransformerFactory tff = TransformerFactory.newInstance();
					Transformer tf = tff.newTransformer();
					tf.setOutputProperty(OutputKeys.ENCODING, "Shift_JIS");
					tf.transform(new DOMSource(doc), new StreamResult("current.xml"));
					break;
				}
			}
		}
	}
	private void writeOval(String type, int x, int y, int width, int height,
		int degrees0, int degrees1, String color) throws Exception
	{
		DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
		DocumentBuilder db = dbf.newDocumentBuilder();
		Document doc = db.parse(new FileInputStream("current.xml"));
		Element root = doc.getDocumentElement();
		for(Node n = root.getFirstChild(); n != null; n.getNextSibling())
		{
			if(n.getNodeType() == Node.ELEMENT_NODE)
			{
				if(n.getNodeName().equals("shape"))
				{
					Element Oval = doc.createElement("oval");
					n.appendChild(Oval);
					Oval.setAttribute("Line", type);
					Oval.setAttribute("Color", color);
					Element X = doc.createElement("x");
					Oval.appendChild(X);
					Text txtX = doc.createTextNode(Integer.toString(x));
					X.appendChild(txtX);
					Element Y = doc.createElement("y");
					Oval.appendChild(Y);
					Text txtY = doc.createTextNode(Integer.toString(y));
					Y.appendChild(txtY);
					Element Width = doc.createElement("width");
					Oval.appendChild(Width);
					Text txtWidth = doc.createTextNode(Integer.toString(width));
					Width.appendChild(txtWidth);
					Element Height = doc.createElement("height");
					Oval.appendChild(Height);
					Text txtHeight = doc.createTextNode(Integer.toString(height));
					Height.appendChild(txtHeight);
					Element Degrees0 = doc.createElement("degrees0");
					Oval.appendChild(Degrees0);
					Text txtDegrees0 = doc.createTextNode(Integer.toString(degrees0));
					Degrees0.appendChild(txtDegrees0);
					Element Degrees1 = doc.createElement("degrees1");
					Oval.appendChild(Degrees1);
					Text txtDegrees1 = doc.createTextNode(Integer.toString(degrees1));
					Degrees1.appendChild(txtDegrees1);
					TransformerFactory tff = TransformerFactory.newInstance();
					Transformer tf = tff.newTransformer();
					tf.setOutputProperty(OutputKeys.ENCODING, "Shift_JIS");
					tf.transform(new DOMSource(doc), new StreamResult("current.xml"));
					break;
				}
			}
		}
	}
	private void setGraphics(Graphics g)
	{
		graphics = g;
	}
	private Graphics getMyGraphics()
	{
		return graphics;
	}
	private void setColor(String color)
	{
		graphics.setColor(Color.BLUE);
		if(color.equals("Color.RED"))
		{
			graphics.setColor(Color.RED);
		}
		else if(color.equals("Color.YELLOW"))
		{
			graphics.setColor(Color.YELLOW);
		}
		else if(color.equals("Color.GREEN"))
		{
			graphics.setColor(Color.GREEN);
		}
		else if(color.equals("Color.CYAN"))
		{
			graphics.setColor(Color.CYAN);
		}
		else if(color.equals("Color.MAGENTA"))
		{
			graphics.setColor(Color.MAGENTA);
		}
	}
	private Color getColor()
	{
		return graphics.getColor();
	}
	public void mouseClicked(MouseEvent me)
	{
		if(mode.equals("pointer"))
		{
			dotPointChangeX = structX;
			dotPointChangeY = structY;
			repaint();
		}
		else if(mode.equals("atext"))
		{
			if((clickTX == -1) && (clickTY == -1))
			{
				try{
					clickTX = (int) ((me.getX() / zoom) + H);
					clickTY = (int) ((me.getY() / zoom) + V);
					BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
					clickFont = chfont;
					System.out.print("FontSize = ");
					clickFontSize = br.readLine();
					clickColor = chcolor;
					System.out.print("Text = ");
					clickText = br.readLine();
					PrintLn(clickTX, clickTY, clickFont, clickFontSize, clickText, clickColor);
					repaint();
					clickTX = -1;
					clickTY = -1;
				}catch(Exception e){}
			}
		}
		else if(mode.equals("line"))
		{
			if((clickX1 == -1) && (clickY1 == -1))
			{
				clickX1 = (int) ((me.getX() / zoom) + H);
				clickY1 = (int) ((me.getY() / zoom) + V);
				clickX2 = -1;
				clickY2 = -1;
				repaint();
			}
			else
			{
				try{
					clickX2 = (int) ((me.getX() / zoom) + H);
					clickY2 = (int) ((me.getY() / zoom) + V);
					repaint();
					writeLine(chline, clickX1, clickY1, clickX2, clickY2, chcolor);
					repaint();
					clickX1 = -1;
					clickY1 = -1;
				}catch(Exception e){}
			}
		}
		else if(mode.equals("linecontinue"))
		{
			if((clickContinueX1 == -1) && (clickContinueY1 == -1))
			{
				clickContinueX1 = (int) ((me.getX() / zoom) + H);
				clickContinueY1 = (int) ((me.getY() / zoom) + V);
				clickContinueX2 = -1;
				clickContinueY2 = -1;
			}
			else
			{
				try{
					clickContinueX2 = (int) ((me.getX() / zoom) + H);
					clickContinueY2 = (int) ((me.getY() / zoom) + V);
					if((clickContinueX1 != clickContinueX2)
						|| (clickContinueY1 != clickContinueY2))
					{
						repaint();
						writeLine(chline, clickContinueX1, clickContinueY1,
							clickContinueX2, clickContinueY2, chcolor);
						repaint();
						clickContinueX1 = (int) ((me.getX() / zoom) + H);
						clickContinueY1 = (int) ((me.getY() / zoom) + V);
						clickContinueX2 = -1;
						clickContinueY2 = -1;
					}
					else
					{
						clickContinueX1 = -1;
						clickContinueY1 = -1;
					}
				}catch(Exception e){}
			}
		}
		else if(mode.equals("rect"))
		{
			if((clickRectX1 == -1) && (clickRectY1 == -1))
			{
				clickRectX1 = (int) ((me.getX() / zoom) + H);
				clickRectY1 = (int) ((me.getY() / zoom) + V);
				clickRectX2 = -1;
				clickRectY2 = -1;
			}
			else
			{
				try{
					clickRectX2 = (int) ((me.getX() / zoom) + H);
					clickRectY2 = (int) ((me.getY() / zoom) + V);
					repaint();
					writeLine(chline, clickRectX1, clickRectY1, clickRectX2, clickRectY1, chcolor);
					writeLine(chline, clickRectX2, clickRectY1, clickRectX2, clickRectY2, chcolor);
					writeLine(chline, clickRectX2, clickRectY2, clickRectX1, clickRectY2, chcolor);
					writeLine(chline, clickRectX1, clickRectY2, clickRectX1, clickRectY1, chcolor);
					repaint();
					clickRectX1 = -1;
					clickRectY1 = -1;
				}catch(Exception e){}
			}
		}
		else if(mode.equals("oval"))
		{
			if((clickX == -1) && (clickY == -1))
			{
				clickX = (int) ((me.getX() / zoom) + H);
				clickY = (int) ((me.getY() / zoom) + V);
				clickWidth = -1;
				clickHeight = -1;
			}
			else
			{
				try{
					clickWidth = (((int) ((me.getX() / zoom) + H)) - clickX) * 2;
					clickHeight = (((int) ((me.getY() / zoom) + V)) - clickY) * 2;
					if(clickWidth < 0) clickWidth = -clickWidth;
					if(clickHeight < 0) clickHeight = -clickHeight;
					BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
					System.out.print("degrees0 = ");
					clickDegrees0 = Integer.parseInt(br.readLine());
					System.out.print("degrees1 = ");
					clickDegrees1 = Integer.parseInt(br.readLine());
					writeOval(chline, clickX, clickY, clickWidth, clickHeight,
						clickDegrees0, clickDegrees1, chcolor);
					repaint();
					clickX = -1;
					clickY = -1;
				}catch(Exception e){}
			}
		}
		else if(mode.equals("eraser"))
		{
			pointX1 = (int) ((me.getX() / zoom) + H);
			pointY1 = (int) ((me.getY() / zoom) + V);
			pointX2 = (int) ((me.getX() / zoom) + H);
			pointY2 = (int) ((me.getY() / zoom) + V);
			repaint();
		}
	}
	public void mousePressed(MouseEvent me)
	{
		if(mode.equals("move") || mode.equals("copy"))
		{
			if((pointX5 == 0) && (pointY5 == 0))
			{
				tmpPointX1 = (int) ((me.getX() / zoom) + H);
				tmpPointY1 = (int) ((me.getY() / zoom) + V);
				tmpPointX2 = (int) ((me.getX() / zoom) + H);
				tmpPointY2 = (int) ((me.getY() / zoom) + V);
			}
			else
			{
				tmpPointX1 = -1;
				tmpPointY1 = -1;
				tmpPointX2 = -1;
				tmpPointY2 = -1;
			}
			pointX5 = pointX4;
			pointY5 = pointY4;
			repaint();
		}
		else if(mode.equals("eraser"))
		{
			pointX1 = (int) ((me.getX() / zoom) + H);
			pointY1 = (int) ((me.getY() / zoom) + V);
			pointX2 = (int) ((me.getX() / zoom) + H);
			pointY2 = (int) ((me.getY() / zoom) + V);
			repaint();
		}
	}
	public void mouseReleased(MouseEvent me) {
		if(mode.equals("move") || mode.equals("copy"))
		{
			if((tmpPointX1 != -1) && (tmpPointY1 != -1) && (tmpPointX2 != -1) && (tmpPointY2 != -1))
			{
				pointX1 = tmpPointX1;
				pointY1 = tmpPointY1;
				pointX2 = tmpPointX2;
				pointY2 = tmpPointY2;
				pointX3 = (int) ((me.getX() / zoom) + H);
				pointY3 = (int) ((me.getY() / zoom) + V);
				pointX4 = 0;
				pointY4 = 0;
				pointX5 = 0;
				pointY5 = 0;
			}
			else
			{
				pointX3 = -1;
				pointY3 = -1;
				pointX4 = 0;
				pointY4 = 0;
				pointX5 = 0;
				pointY5 = 0;
			}
		}
	}
	public void mouseEntered(MouseEvent me) {
		System.out.println("mouseEntered");
	}
	public void mouseExited(MouseEvent me) {
		System.out.println("mouseExited");
	}
	public void mouseDragged(MouseEvent me) {
		if(mode.equals("move") || mode.equals("copy"))
		{
			if((tmpPointX1 != -1) && (tmpPointY1 != -1))
			{
				tmpPointX2 = (int) ((me.getX() / zoom) + H);
				tmpPointY2 = (int) ((me.getY() / zoom) + V);
				pointX3 = -1;
				pointY3 = -1;
				pointX4 = 0;
				pointY4 = 0;
				pointX5 = 0;
				pointY5 = 0;
			}
			else
			{
				tmpPointX2 = -1;
				tmpPointY2 = -1;
				pointX3 = -1;
				pointY3 = -1;
				pointX4 = 0;
				pointY4 = 0;
				pointX5 = 0;
				pointY5 = 0;
			}
			repaint();
		}
		if(mode.equals("eraser"))
		{
			pointX2 = (int) ((me.getX() / zoom) + H);
			pointY2 = (int) ((me.getY() / zoom) + V);
			repaint();
		}
	}
	public void mouseMoved(MouseEvent me)
	{
		if(mode.equals("pointer"))
		{
			structX = (int) ((me.getX() / zoom) + H);
			structY = (int) ((me.getY() / zoom) + V);
			repaint();
		}
		else
		{
			dotPointChangeX = -1;
			dotPointChangeY = -1;
		}
		if(mode.equals("atext"))
		{
			structX = (int) ((me.getX() / zoom) + H);
			structY = (int) ((me.getY() / zoom) + V);
			repaint();
		}
		else
		{
			clickTX = -1;
			clickTY = -1;
		}
		if(mode.equals("line"))
		{
			structX = (int) ((me.getX() / zoom) + H);
			structY = (int) ((me.getY() / zoom) + V);
			repaint();
		}
		else
		{
			clickX1 = -1;
			clickY1 = -1;
			clickX2 = -1;
			clickY2 = -1;
		}
		if(mode.equals("linecontinue"))
		{
			structX = (int) ((me.getX() / zoom) + H);
			structY = (int) ((me.getY() / zoom) + V);
			repaint();
		}
		else
		{
			clickContinueX1 = -1;
			clickContinueY1 = -1;
			clickContinueX2 = -1;
			clickContinueY2 = -1;
		}
		if(mode.equals("rect"))
		{
			structX = (int) ((me.getX() / zoom) + H);
			structY = (int) ((me.getY() / zoom) + V);
			repaint();
		}
		else
		{
			clickRectX1 = -1;
			clickRectY1 = -1;
			clickRectX2 = -1;
			clickRectY2 = -1;
		}
		if(mode.equals("oval"))
		{
			structX = (int) ((me.getX() / zoom) + H);
			structY = (int) ((me.getY() / zoom) + V);
			repaint();
		}
		else
		{
			clickX = -1;
			clickY = -1;
			clickWidth = -1;
			clickHeight = -1;
			clickDegrees0 = 0;
			clickDegrees1 = 0;
		}
		if(mode.equals("move") || mode.equals("copy"))
		{
			if((tmpPointX1 != -1) && (tmpPointY1 != -1) && (tmpPointX2 != -1) && (tmpPointY2 != -1)
				&& (pointX3 != -1) && (pointY3 != -1))
			{
				pointX4 = ((int) ((me.getX() / zoom) + H)) - pointX3;
				pointY4 = ((int) ((me.getY() / zoom) + V)) - pointY3;
				pointX5 = 0;
				pointY5 = 0;
			}
			else
			{
				pointX4 = 0;
				pointY4 = 0;
				pointX5 = 0;
				pointY5 = 0;
			}
			repaint();
		}
	}
	private boolean getPDistance(int x1, int y1, int x2, int y2)
	{
		int tmpX1 = -1;
		int tmpY1 = -1;
		int tmpX2 = -1;
		int tmpY2 = -1;
		if(pointX2 < pointX1)
		{
			tmpX1 = pointX2;
			tmpX2 = pointX1;
		}
		else
		{
			tmpX1 = pointX1;
			tmpX2 = pointX2;
		}
		if(pointY2 < pointY1)
		{
			tmpY1 = pointY2;
			tmpY2 = pointY1;
		}
		else
		{
			tmpY1 = pointY1;
			tmpY2 = pointY2;
		}
		for(pointX = tmpX1; pointX <= tmpX2; pointX++)
		{
			for(pointY = tmpY1; pointY <= tmpY2; pointY++)
			{
				pd1 = ((y2 - y1) * (pointX - x1)) - ((x2 - x1) * (pointY - y1));
				if(pd1 < 0)
				{
					pd1 = -pd1;
				}
				pd2 = (int) Math.sqrt(Math.pow((y2 - y1), 2) + Math.pow((x2 - x1), 2));
				if(pd2 == 0)
				{
					return true;
				}
				pd4 = true;
				if(x2 >= x1)
				{
					if(pointX > x2 + CPDM) pd4 = false;
					else if(pointX < x1 - CPDM) pd4 = false;
				}
				else if(x2 < x1)
				{
					if(pointX > x1 + CPDM) pd4 = false;
					else if(pointX < x2 - CPDM) pd4 = false;
				}
				if(y2 >= y1)
				{
					if(pointY > y2 + CPDM) pd4 = false;
					else if(pointY < y1 - CPDM) pd4 = false;
				}
				else if(y2 < y1)
				{
					if(pointY > y1 + CPDM) pd4 = false;
					else if(pointY < y2 - CPDM) pd4 = false;
				}
				pd3 = (int)(pd1 / pd2);
				if((pd3 >= 0) && (pd3 <= CPDM) && pd4)
				{
					pd4 = true;
					return pd4;
				}
			}
		}
		return false;
	}
	
	private boolean getDotPDistance(int x, int y, int px1, int py1, int px2, int py2)
	{
		int tmpX1 = -1;
		int tmpY1 = -1;
		int tmpX2 = -1;
		int tmpY2 = -1;
		if(px2 < px1)
		{
			tmpX1 = px2;
			tmpX2 = px1;
		}
		else
		{
			tmpX1 = px1;
			tmpX2 = px2;
		}
		if(py2 < py1)
		{
			tmpY1 = py2;
			tmpY2 = py1;
		}
		else
		{
			tmpY1 = py1;
			tmpY2 = py2;
		}
		for(pointX = tmpX1; pointX <= tmpX2; pointX++)
		{
			for(pointY = tmpY1; pointY <= tmpY2; pointY++)
			{
				pd1 = (int) Math.sqrt(Math.pow((pointX - x), 2) + Math.pow((pointY - y), 2));
				if(pd1 <= CPDM)
				{
					return true;
				}
			}
		}
		return false;
	}
	
	private boolean getOvalPDistance(int x, int y, int w, int h)
	{
		int tmpX1 = -1;
		int tmpY1 = -1;
		int tmpX2 = -1;
		int tmpY2 = -1;
		if(pointX2 < pointX1)
		{
			tmpX1 = pointX2;
			tmpX2 = pointX1;
		}
		else
		{
			tmpX1 = pointX1;
			tmpX2 = pointX2;
		}
		if(pointY2 < pointY1)
		{
			tmpY1 = pointY2;
			tmpY2 = pointY1;
		}
		else
		{
			tmpY1 = pointY1;
			tmpY2 = pointY2;
		}
		for(pointX = tmpX1; pointX <= tmpX2; pointX++)
		{
			for(pointY = tmpY1; pointY <= tmpY2; pointY++)
			{
				if(w < 0) w = -w;
				if(h < 0) h = -h;
				
				if((pointX < x - ((int) (w / 2.0)) - CPDM) || (pointX > x + ((int) (w / 2.0)) + CPDM)
					|| (pointY < y - ((int) (h / 2.0)) - CPDM) || (pointY > y + ((int) (h / 2.0)) + CPDM))
				{
					continue;
				}
				
				pd5 = (1 - (Math.pow((pointY - y), 2) / Math.pow((h / 2.0), 2))) * Math.pow((w / 2.0), 2);
				if(pd5 < 0)
				{
					pd5 = -pd5;
				}
				pd5	= Math.sqrt(pd5) - pointX + x;
				if(pd5 < 0)
				{
					pd5 = -pd5;
				}
				if(pd5 <= CPDMOval)
				{
					return true;
				}
				pd5 = (1 - (Math.pow((pointX - x), 2) / Math.pow((w / 2.0), 2))) * Math.pow((h / 2.0), 2);
				if(pd5 < 0)
				{
					pd5 = -pd5;
				}
				pd5	= Math.sqrt(pd5) - pointY + y;
				if(pd5 < 0)
				{
					pd5 = -pd5;
				}
				if(pd5 <= CPDMOval)
				{
					return true;
				}
				
				continue;
			}
		}
		return false;
	}
	
	public void setMode(String m)
	{
		mode = m;
		return;
	}
	public static void setSMode(String m)
	{
		mode = m;
		return;
	}
	public static void setChFont(String cf)
	{
		if(cf.equals("PLAIN"))
		{
			chfont = "Font.PLAIN";
		}
		else if(cf.equals("BOLD"))
		{
			chfont = "Font.BOLD";
		}
		else if(cf.equals("ITALIC"))
		{
			chfont = "Font.ITALIC";
		}
		return;
	}
	public static void setChLine(String cl)
	{
		if(cl.equals("REALLINE"))
		{
			chline = "RealLine";
		}
		else if(cl.equals("SUBLINE"))
		{
			chline = "SubLine";
		}
		else if(cl.equals("ARROWLINE"))
		{
			chline = "ArrowLine";
		}
		return;
	}
	
	public static String getChLine()
	{
		return chline;
	}
	
	public static void setChColor(String cc)
	{
		if(cc.equals("BLUE"))
		{
			chcolor = "Color.BLUE";
		}
		else if(cc.equals("GREEN"))
		{
			chcolor = "Color.GREEN";
		}
		else if(cc.equals("CYAN"))
		{
			chcolor = "Color.CYAN";
		}
		else if(cc.equals("MAGENTA"))
		{
			chcolor = "Color.MAGENTA";
		}
		return;
	}
	
	public static String getChColor()
	{
		return chcolor;
	}
	
	public int getMyFont()
	{
		if(chfont.equals("Font.BOLD"))
		{
			return Font.BOLD;
		}
		else if(chfont.equals("Font.ITALIC"))
		{
			return Font.ITALIC;
		}
		else
		{
			return Font.PLAIN;
		}
	}
	
	public static void setV(int v)
	{
		V = v;
		return;
	}
	
	public static void setH(int h)
	{
		H = h;
		return;
	}
	
	public static void setChBGColor(String cbgc)
	{
		chbgcolor = cbgc;
	}
}
