import java.io.*;
import java.awt.*;
import java.net.*;
import java.awt.image.*;
import java.awt.print.*;
import javax.print.*;
import javax.print.attribute.*;
import javax.print.attribute.standard.*;
import javax.xml.parsers.*;
import javax.xml.transform.*;
import javax.xml.transform.stream.*;
import javax.xml.transform.dom.*;
import org.w3c.dom.*;

public class CAD_Print2DPrinterJob implements Printable {

	public CAD_Print2DPrinterJob() {

		/* Construct the print request specification.
		* The print data is a Printable object.
		* the request additonally specifies a job name, 2 copies, and
		* landscape orientation of the media.
		*/
		PrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
		aset.add(OrientationRequested.LANDSCAPE);
		aset.add(new Copies(1));
		aset.add(new JobName("My job", null));

		/* Create a print job */
		PrinterJob pj = PrinterJob.getPrinterJob();       
		pj.setPrintable(this);
		/* locate a print service that can handle the request */
		PrintService[] services =
			PrinterJob.lookupPrintServices();

		if (services.length > 0) {
			System.out.println("selected printer " + services[0].getName());
			try {
				pj.setPrintService(services[0]);
				pj.pageDialog(aset);
				if(pj.printDialog(aset)) {
					pj.print(aset);
				}
			} catch (PrinterException pe) { 
				System.err.println(pe);
			}
		}
	}

	public int print(Graphics g,PageFormat pf,int pageIndex) {

		if (pageIndex == 0)
		{
			Graphics2D g2d= (Graphics2D)g;
			g2d.translate(pf.getImageableX(), pf.getImageableY()); 
			// write
			try{
				g2d.setColor(Color.WHITE);
				// Read DOM & current.xml
				// ---
				//
				int x1 = 0;
				int y1 = 0;
				int x2 = 0;
				int y2 = 0;
				int x = 0;
				int y = 0;
				int Width = 0;
				int Height = 0;
				int degrees0 = 0;
				int degrees1 = 360;
				int redX = 0;
				int redY = 0;
				int dotX = 0;
				int dotY = 0;
				String strColor = CAD_JPrint.getChColor();
				String strType1 = "line";
				String strType2 = CAD_JPrint.getChLine();
				String strFont1 = "Sherif";
				String strFont2 = "Font.PLAIN";
				String strSize = "20";
				String strX = "-1";
				String strY = "-1";
				String strX1 = "-1";
				String strY1 = "-1";
				String strX2 = "-1";
				String strY2 = "-1";
				String strWidth = "0";
				String strHeight = "0";
				String strDegrees0 = "0";
				String strDegrees1 = "360";
				String strText = "";
				String strDotX = "-1";
				String strDotY = "-1";
				int H = 0;
				int V = 0;
				double zoom = 1.0;
				int width = 700;
				int height = 700;
				
				DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
				DocumentBuilder db = dbf.newDocumentBuilder();
				Document doc = db.parse(new FileInputStream("CAD_Current.xml"));
				Element root = doc.getDocumentElement();
				
				for(Node n1 = root.getFirstChild(); n1 != null; n1 = n1.getNextSibling())
				{
					if(n1.getNodeType() == Node.ELEMENT_NODE)
					{
						if(n1.getNodeName().equals("shapes"))
						{
							for(Node n2 = n1.getFirstChild(); n2 != null; n2 = n2.getNextSibling())
							{
								if(n2.getNodeType() == Node.ELEMENT_NODE)
								{
									if(n2.getNodeName().equals("schematic"))
									{
										for(Node n3 = n2.getFirstChild(); n3 != null; n3 = n3.getNextSibling())
										{
											if(n3.getNodeType() == Node.ELEMENT_NODE)
											{
												if(n3.getNodeName().equals("shape"))
												{
													for(Node ch = n3.getFirstChild(); ch != null; ch = ch.getNextSibling())
													{
														if(ch.getNodeType() == Node.ELEMENT_NODE)
														{
															if(ch.getNodeName().equals("text"))
															{
																strType1 = "text";
																strFont1 = "Sherif";
																try{
																	strFont2 = ch.getAttributes().getNamedItem("Font").getNodeValue();
																	strSize = ch.getAttributes().getNamedItem("FontSize").getNodeValue();
																	strColor = ch.getAttributes().getNamedItem("Color").getNodeValue();
																	strX = ch.getAttributes().getNamedItem("X").getNodeValue();
																	strY = ch.getAttributes().getNamedItem("Y").getNodeValue();
																}catch(Exception e){}
																for(Node ch2 = ch.getFirstChild(); ch2 != null; ch2 = ch2.getNextSibling())
																{
																	if(ch2.getNodeType() == Node.TEXT_NODE)
																	{
																		strText = ch2.getNodeValue();
																	}
																}
																// setFont
																int s = 20;
																try{
																	s = Integer.parseInt(strSize);
																}catch(Exception e){}
																g2d.setFont(new Font(strFont1, Font.PLAIN, s));
																if(strFont2.equals("Font.BOLD"))
																{
																	g2d.setFont(new Font(strFont1, Font.BOLD, s));
																}
																else if(strFont2.equals("Font.ITALIC"))
																{
																	g2d.setFont(new Font(strFont1, Font.ITALIC, s));
																}
																// setColor
																g2d.setColor(Color.BLUE);
																if(strColor.equals("Color.RED"))
																{
																	g2d.setColor(Color.RED);
																}
																else if(strColor.equals("Color.YELLOW"))
																{
																	g2d.setColor(Color.YELLOW);
																}
																else if(strColor.equals("Color.GREEN"))
																{
																	g2d.setColor(Color.GREEN);
																}
																else if(strColor.equals("Color.CYAN"))
																{
																	g2d.setColor(Color.CYAN);
																}
																else if(strColor.equals("Color.MAGENTA"))
																{
																	g2d.setColor(Color.MAGENTA);
																}
																g2d.drawString(strText, (int) ((Integer.parseInt(strX) + redX - H) * zoom),
																	(int) ((Integer.parseInt(strY) + redY - V) * zoom));
															}
															if(ch.getNodeName().equals("line"))
															{
																strType1 = "line";
																try{
																	strType2 = ch.getAttributes().getNamedItem("Line").getNodeValue();
																	strColor = ch.getAttributes().getNamedItem("Color").getNodeValue();
																}catch(Exception e){}
																int ix = 0;
																int iy = 0;
																for(Node ch2 = ch.getFirstChild(); ch2 != null; ch2 = ch2.getNextSibling())
																{
																	if(ch2.getNodeType() == Node.ELEMENT_NODE)
																	{
																		if(ch2.getNodeName().equals("dot"))
																		{
																			for(Node ch3 = ch2.getFirstChild(); ch3 != null; ch3 = ch3.getNextSibling())
																			{
																				if(ch3.getNodeType() == Node.ELEMENT_NODE)
																				{
																					if(ch3.getNodeName().equals("x"))
																					{
																						for(Node ch4 = ch3.getFirstChild(); ch4 != null; ch4 = ch4.getNextSibling())
																						{
																							if(ch4.getNodeType() == Node.TEXT_NODE)
																							{
																								if(ix == 0)
																								{
																									strX1 = ch4.getNodeValue();
																									x1 = Integer.parseInt(strX1);
																								}
																								if(ix == 1)
																								{
																									strX2 = ch4.getNodeValue();
																									x2 = Integer.parseInt(strX2);
																								}
																								ix++;
																							}
																						}
																					}
																					else if(ch3.getNodeName().equals("y"))
																					{
																						for(Node ch4 = ch3.getFirstChild(); ch4 != null; ch4 = ch4.getNextSibling())
																						{
																							if(ch4.getNodeType() == Node.TEXT_NODE)
																							{
																								if(iy == 0)
																								{
																									strY1 = ch4.getNodeValue();
																									y1 = Integer.parseInt(strY1);
																								}
																								if(iy == 1)
																								{
																									strY2 = ch4.getNodeValue();
																									y2 = Integer.parseInt(strY2);
																									break;
																								}
																								iy++;
																							}
																						}
																					}
																				}
																			}
																		}
																	}
																}
																if(strType1.equals("line"))
																{
																	// setColor
																	g2d.setColor(Color.BLUE);
																	if(strColor.equals("Color.RED"))
																	{
																		g2d.setColor(Color.RED);
																	}
																	else if(strColor.equals("Color.YELLOW"))
																	{
																		g2d.setColor(Color.YELLOW);
																	}
																	else if(strColor.equals("Color.GREEN"))
																	{
																		g2d.setColor(Color.GREEN);
																	}
																	else if(strColor.equals("Color.CYAN"))
																	{
																		g2d.setColor(Color.CYAN);
																	}
																	else if(strColor.equals("Color.MAGENTA"))
																	{
																		g2d.setColor(Color.MAGENTA);
																	}
																	// drawRealLine
																	if(strType2.equals("RealLine"))
																	{
																		for(int i = -1; i < 2; i++)
																		{
																			for(int j = -1; j < 2; j++)
																			{
																				g2d.drawLine((int) ((x1 + redX - H) * zoom) + i,
																				 (int) ((y1 + redY - V) * zoom) + j,
																				 (int) ((x2 + redX - H) * zoom) + i,
																				 (int) ((y2 + redY - V) * zoom) + j);
																			}
																		}
																	}
																	// drawArrowLine
																	else if(strType2.equals("ArrowLine"))
																	{
																		g2d.drawLine((int) ((x1 + redX - H) * zoom),
																		 (int) ((y1 + redY - V) * zoom),
																		 (int) ((x2 + redX - H) * zoom),
																		 (int) ((y2 + redY - V) * zoom));
																		// drawArrow
																		double rad;
																		int fugoX;
																		int fugoY;
																		rad = 0;
																		fugoX = 1;
																		fugoY = 1;
																		if(x2 > x1)
																		{
																			fugoX = 1;
																		}
																		else if(x2 < x1)
																		{
																			fugoX = (-1);
																		}
																		
																		if(y2 > y1)
																		{
																			fugoY = 1;
																		}
																		else if(y2 < y1)
																		{
																			fugoY = (-1);
																		}
																		
																		if(x1 == x2)
																		{
																			rad = (Math.PI / 2);
																		}
																		else
																		{
																			rad = Math.atan((y2 - y1) / (x2 - x1));
																			
																			if(rad < 0)
																			{
																				rad = -rad;
																			}
																		}
																		g2d.drawLine((int) ((x1 + redX - H) * zoom),
																		 (int) ((y1 + redY - V) * zoom),
																		 (int) (((x1 + redX - H) * zoom) + fugoX * 10 * Math.cos(rad + (Math.PI / 6))),
																		 (int) (((y1 + redY - V) * zoom) + fugoY * 10 * Math.sin(rad + (Math.PI / 6))));
																		g2d.drawLine((int) ((x1 + redX - H) * zoom),
																		 (int) ((y1 + redY - V) * zoom),
																		 (int) (((x1 + redX - H) * zoom) + fugoX * 10 * Math.cos(rad - (Math.PI / 6))),
																		 (int) (((y1 + redY - V) * zoom) + fugoY * 10 * Math.sin(rad - (Math.PI / 6))));
																		rad += Math.PI;
																		g2d.drawLine((int) ((x2 + redX - H) * zoom),
																		 (int) ((y2 + redY - V) * zoom),
																		 (int) (((x2 + redX - H) * zoom) + fugoX * 10 * Math.cos(rad + (Math.PI / 6))),
																		 (int) (((y2 + redY - V) * zoom) + fugoY * 10 * Math.sin(rad + (Math.PI / 6))));
																		g2d.drawLine((int) ((x2 + redX - H) * zoom),
																		 (int) ((y2 + redY - V) * zoom),
																		 (int) (((x2 + redX - H) * zoom) + fugoX * 10 * Math.cos(rad - (Math.PI / 6))),
																		 (int) (((y2 + redY - V) * zoom) + fugoY * 10 * Math.sin(rad - (Math.PI / 6))));
																	}
																	// drawSubLine
																	else
																	{
																		g2d.drawLine((int) ((x1 + redX - H) * zoom), (int) ((y1 + redY - V) * zoom),
																		 (int) ((x2 + redX - H) * zoom), (int) ((y2 + redY - V) * zoom));
																	}
																}
															}
															else if(ch.getNodeName().equals("oval"))
															{
																strType1 = "oval";
																try{
																	strType2 = ch.getAttributes().getNamedItem("Line").getNodeValue();
																	strColor = ch.getAttributes().getNamedItem("Color").getNodeValue();
																}catch(Exception e){}
																for(Node ch2 = ch.getFirstChild(); ch2 != null; ch2 = ch2.getNextSibling())
																{
																	if(ch2.getNodeType() == Node.ELEMENT_NODE)
																	{
																		if(ch2.getNodeName().equals("x"))
																		{
																			for(Node ch3 = ch2.getFirstChild(); ch3 != null; ch3 = ch3.getNextSibling())
																			{
																				if(ch3.getNodeType() == Node.TEXT_NODE)
																				{
																					strX = ch3.getNodeValue();
																					x = Integer.parseInt(strX);
																				}
																			}
																		}
																		else if(ch2.getNodeName().equals("y"))
																		{
																			for(Node ch3 = ch2.getFirstChild(); ch3 != null; ch3 = ch3.getNextSibling())
																			{
																				if(ch3.getNodeType() == Node.TEXT_NODE)
																				{
																					strY = ch3.getNodeValue();
																					y = Integer.parseInt(strY);
																				}
																			}
																		}
																		if(ch2.getNodeName().equals("width"))
																		{
																			for(Node ch3 = ch2.getFirstChild(); ch3 != null; ch3 = ch3.getNextSibling())
																			{
																				if(ch3.getNodeType() == Node.TEXT_NODE)
																				{
																					strWidth = ch3.getNodeValue();
																					Width = Integer.parseInt(strWidth);
																				}
																			}
																		}
																		else if(ch2.getNodeName().equals("height"))
																		{
																			for(Node ch3 = ch2.getFirstChild(); ch3 != null; ch3 = ch3.getNextSibling())
																			{
																				if(ch3.getNodeType() == Node.TEXT_NODE)
																				{
																					strHeight = ch3.getNodeValue();
																					Height = Integer.parseInt(strHeight);
																				}
																			}
																		}
																		if(ch2.getNodeName().equals("degrees0"))
																		{
																			for(Node ch3 = ch2.getFirstChild(); ch3 != null; ch3 = ch3.getNextSibling())
																			{
																				if(ch3.getNodeType() == Node.TEXT_NODE)
																				{
																					strDegrees0 = ch3.getNodeValue();
																					degrees0 = Integer.parseInt(strDegrees0);
																				}
																			}
																		}
																		else if(ch2.getNodeName().equals("degrees1"))
																		{
																			for(Node ch3 = ch2.getFirstChild(); ch3 != null; ch3 = ch3.getNextSibling())
																			{
																				if(ch3.getNodeType() == Node.TEXT_NODE)
																				{
																					strDegrees1 = ch3.getNodeValue();
																					degrees1 = Integer.parseInt(strDegrees1);
																				}
																			}
																		}
																	}
																}
																if(strType1.equals("oval"))
																{
																	// setColor
																	g2d.setColor(Color.BLUE);
																	if(strColor.equals("Color.RED"))
																	{
																		g2d.setColor(Color.RED);
																	}
																	else if(strColor.equals("Color.YELLOW"))
																	{
																		g2d.setColor(Color.YELLOW);
																	}
																	else if(strColor.equals("Color.GREEN"))
																	{
																		g2d.setColor(Color.GREEN);
																	}
																	else if(strColor.equals("Color.CYAN"))
																	{
																		g2d.setColor(Color.CYAN);
																	}
																	else if(strColor.equals("Color.MAGENTA"))
																	{
																		g2d.setColor(Color.MAGENTA);
																	}
																	// drawOval
																	if(width < 0) width = -width;
																	if(height < 0) height = -height;
																	
																	if(strType2.equals("RealLine"))
																	{
																		for(int i = -1; i <= 1; i++)
																		{
																			for(int j = -1; j <= 1; j++)
																			{
																				g2d.drawArc(((int) (((x + redX) - (Width / 2.0) - H) * zoom)) + i,
																					((int) (((y + redY) - (Height / 2.0) - V) * zoom)) + j,
																					((int) (Width * zoom)), ((int) (Height * zoom)),
																					degrees0, degrees1);
																			}
																		}
																	}
																	else
																	{
																		g2d.drawArc(((int) (((x + redX) - (Width / 2.0) - H) * zoom)),
																			((int) (((y + redY) - (Height / 2.0) - V) * zoom)),
																			((int) (Width * zoom)), ((int) (Height * zoom)),
																			degrees0, degrees1);
																	}
																}
															}
															if(ch.getNodeName().equals("dot"))
															{
																strType1 = "dot";
																try{
																	strType2 = ch.getAttributes().getNamedItem("Dot").getNodeValue();
																	strColor = ch.getAttributes().getNamedItem("Color").getNodeValue();
																}catch(Exception e){}
																int ix = 0;
																int iy = 0;
																for(Node ch2 = ch.getFirstChild(); ch2 != null; ch2 = ch2.getNextSibling())
																{
																	if(ch2.getNodeType() == Node.ELEMENT_NODE)
																	{
																		if(ch2.getNodeName().equals("x"))
																		{
																			for(Node ch3 = ch2.getFirstChild(); ch3 != null; ch3 = ch3.getNextSibling())
																			{
																				if(ch3.getNodeType() == Node.TEXT_NODE)
																				{
																					strDotX = ch3.getNodeValue();
																					dotX = Integer.parseInt(strDotX);
																				}
																			}
																		}
																		else if(ch2.getNodeName().equals("y"))
																		{
																			for(Node ch3 = ch2.getFirstChild(); ch3 != null; ch3 = ch3.getNextSibling())
																			{
																				if(ch3.getNodeType() == Node.TEXT_NODE)
																				{
																					strDotY = ch3.getNodeValue();
																					dotY = Integer.parseInt(strDotY);
																				}
																			}
																		}
																	}
																}
																if(strType1.equals("dot"))
																{
																	// setColor
																	g2d.setColor(Color.BLUE);
																	if(strColor.equals("Color.RED"))
																	{
																		g2d.setColor(Color.RED);
																	}
																	else if(strColor.equals("Color.YELLOW"))
																	{
																		g2d.setColor(Color.YELLOW);
																	}
																	else if(strColor.equals("Color.GREEN"))
																	{
																		g2d.setColor(Color.GREEN);
																	}
																	else if(strColor.equals("Color.CYAN"))
																	{
																		g2d.setColor(Color.CYAN);
																	}
																	else if(strColor.equals("Color.MAGENTA"))
																	{
																		g2d.setColor(Color.MAGENTA);
																	}
																	// drawRealDot
																	if(strType2.equals("RealDot") || strType2.equals("ElectricDot"))
																	{
																		for(int i = -1; i < 2; i++)
																		{
																			for(int j = -1; j < 2; j++)
																			{
																				g2d.drawLine((int) ((dotX + redX - H) * zoom) + i,
																				 (int) ((dotY + redY - V) * zoom) + j,
																				 (int) ((dotX + redX - H) * zoom) + i,
																				 (int) ((dotY + redY - V) * zoom) + j);
																			}
																		}
																	}
																	// drawSubDot
																	else
																	{
																		g2d.drawLine((int) ((dotX + redX - H) * zoom), (int) ((dotY + redY - V) * zoom),
																		 (int) ((dotX + redX - H) * zoom), (int) ((dotY + redY - V) * zoom));
																	}
																}
															}
														}
													}
													break;
												}
											}
										}
									}
								}
							}
							break;
						}
					}
				}
			}catch(Exception e){}
			// write finish
			return Printable.PAGE_EXISTS;					
		} else {
			return Printable.NO_SUCH_PAGE;
		}
	}
}
