import java.io.*;
import javax.swing.*;

public class CAD_GCode
{
	private static String gc = "";
	
	public CAD_GCode()
	{
		gc = "";
	}
	
	public void clear()
	{
		gc = "";
	}
	
	public static void write()
	{
		int rpm = 1000;
		String programNo = "00001";
		int pN = 1;
		try
		{
			System.out.println("rpm speed = 1000");
			System.out.print("input rpm speed = ");
			BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
			rpm = Integer.parseInt(br.readLine());
		}catch(Exception e){
			rpm = 1000;
		}
		System.out.println("rpm speed = " + rpm);
		try
		{
			System.out.println("program No = 0001 or 0002 or 0003 or ... or 9999");
			System.out.print("input program No = ");
			BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
			pN = Integer.parseInt(br.readLine());
			programNo = Integer.toString(pN);
			if((pN >= 0) && (pN <= 9))
			{
				programNo = "000" + programNo;
			}
			else if((pN >= 10) && (pN <= 99))
			{
				programNo = "00" + programNo;
			}
			else if((pN >= 100) && (pN <= 999))
			{
				programNo = "0" + programNo;
			}
			else if((pN >= 1000) && (pN <= 9999))
			{
			}
			else
			{
				Exception e = new Exception();
				throw e;
			}
		}catch(Exception e){
			programNo = "0001";
		}
		System.out.println("program No = " + programNo);
		System.out.println("Save GCode");
		gc = " %;\n 0" + programNo + ";\n S" + rpm + ";\n M03;\n" + gc + " M05;\n M02;\n %;\n";
		try{
			PrintWriter pw = new PrintWriter(new BufferedWriter(
				new FileWriter("CAD_GCode.txt")));
			pw.println(gc);
			pw.close();
			System.out.println(gc);
		}
		catch(Exception e)
		{
			System.out.println(gc);
		}
		JFileChooser jfc = new JFileChooser();
		int intRet = jfc.showOpenDialog(null);
		if(intRet == JFileChooser.APPROVE_OPTION)
		{
			try{
				final JTextArea myText = new JTextArea();
				myText.setLineWrap(true);
				String strLine;
				File myFile=jfc.getSelectedFile();
				BufferedReader myReader=new BufferedReader(new FileReader(new File("CAD_GCode.txt")));
				myText.setText(myReader.readLine());
				while((strLine=myReader.readLine()) !=null)
				{
					myText.append("\n" + strLine);
				}
				myReader.close();
				PrintWriter myWriter=new PrintWriter(new BufferedWriter(new FileWriter(jfc.getSelectedFile().getAbsolutePath())));
				myWriter.write(myText.getText());
				myWriter.close();
			}catch(Exception e){
				System.out.println(e);
			}
		}
		else
		{
			System.out.println("Save GCode Failed");
		}
		return;
	}
	
	public void G01(String strType2, String strType3, int x1, int y1, int x2, int y2)
	{
		// if(strType2.equals("RealLine"))
		{
			gc += " G00 X" + x1 + ".Y" + y1 + ".;\n";
			if(strType3.equals("Left"))
			{
				gc += " G41 G01 X" + x2 + ".Y" + y2 + ". F120;\n";
			}
			else if(strType3.equals("Right"))
			{
				gc += " G42 G01 X" + x2 + ".Y" + y2 + ". F120;\n";
			}
			else
			{
				gc += " G40 G01 X" + x2 + ".Y" + y2 + ". F120;\n";
			}
			
		}
	}
	
	public void G03(String strType2, String strType3, int x, int y, int w, int h, int d1, int d2)
	{
		// if(strType2.equals("RealLine"))
		{
			gc += " G00 X" + (x + ((int) ((w / 2.0) * Math.cos(d1 * Math.PI / 180.0))));
			gc += ".Y" + (y + ((int) ((h / 2.0) * (-Math.sin(d1 * Math.PI / 180.0))))) + ".;\n";
			if(strType3.equals("Left"))
			{
				gc += " G41 G17 G03 X" + (x + ((int) ((w / 2.0) * Math.cos((d1 + d2) * Math.PI / 180.0))));
			}
			else if(strType3.equals("Right"))
			{
				gc += " G42 G17 G03 X" + (x + ((int) ((w / 2.0) * Math.cos((d1 + d2) * Math.PI / 180.0))));
			}
			else
			{
				gc += " G40 G17 G03 X" + (x + ((int) ((w / 2.0) * Math.cos((d1 + d2) * Math.PI / 180.0))));
			}
			gc += ".Y" + (y + ((int) ((h / 2.0) * (-Math.sin((d1 + d2) * Math.PI / 180.0)))));
			gc += ". I" + x + ".J" + y + ". F60;\n";
		}
	}
	
	public void G83(String strType2, int x, int y)
	{
		// if(strType2.equals("RealLine"))
		{
			gc += " G00 X" + x + ".Y" + y + ".;\n";
			gc += " G83 X" + x + ".Y" + y + ".;\n";
		}
	}
}
