import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

public class CAD_Main extends JFrame implements AdjustmentListener
{
	JScrollBar jsbV;
	JScrollBar jsbH;
	
	public CAD_Main() throws Exception
	{
		this.addWindowListener(new WindowAdapter()
		{
			public void windowClosing(WindowEvent e){
				System.exit(0);
			}
		});
		
		this.getContentPane().setLayout(new BorderLayout());
		
		CAD_ButtonPanel mbp = new CAD_ButtonPanel(800,700);
		this.setSize(800, 700);
		this.getContentPane().add(mbp, BorderLayout.CENTER);
		
		jsbV = new JScrollBar();
		jsbV.setPreferredSize(new Dimension(20, 700));
		jsbV.addAdjustmentListener(this);
		jsbV.setBlockIncrement(25);
		jsbV.setUnitIncrement(2);
		this.getContentPane().add(jsbV, BorderLayout.EAST);
		jsbH = new JScrollBar(JScrollBar.HORIZONTAL);
		jsbH.setPreferredSize(new Dimension(800, 20));
		jsbH.addAdjustmentListener(this);
		jsbH.setBlockIncrement(25);
		jsbH.setUnitIncrement(2);
		this.getContentPane().add(jsbH, BorderLayout.SOUTH);
		
		this.setVisible(true);
	}
	
	public void adjustmentValueChanged(AdjustmentEvent e)
	{
		CAD_JPrint.setH((int) (jsbH.getValue() * 800 / 100.0));
		CAD_JPrint.setV((int) (jsbV.getValue() * 700 / 100.0));
		repaint();
	}
	
	public static void main(String args[]) throws Exception
	{
		try{
			// CAD_Key ck = new CAD_Key();
			CAD_Main cm = new CAD_Main();
			while(true)
			{
				// ck.getKey();
			}
		}
		catch(Exception e)
		{
			System.exit(1);
		}
	}
}
